/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: ProfibusAps_error.h 59656 2016-03-07 15:01:15Z RalfH $

Description:
  This file contains Profibus Aps task error codes

**************************************************************************************/
#ifndef __PROFIBUS_APS_ERROR_H
#define __PROFIBUS_APS_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS APS Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PROFIBUS_APS_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_PROFIBUS_APS_COMMAND_INVALID ((TLR_RESULT)0xC01D0001L)

//
// MessageId: TLR_E_PROFIBUS_APS_ALREADY_CONFIGURED
//
// MessageText:
//
//  Device is already configured. The new configuration is discard.
//
#define TLR_E_PROFIBUS_APS_ALREADY_CONFIGURED ((TLR_RESULT)0xC01D0002L)

//
// MessageId: TLR_E_PROFIBUS_APS_NO_CONFIG_DBM
//
// MessageText:
//
//  No database available.
//
#define TLR_E_PROFIBUS_APS_NO_CONFIG_DBM ((TLR_RESULT)0xC01D0003L)

//
// MessageId: TLR_E_PROFIBUS_APS_CONFIG_DBM_INVALID
//
// MessageText:
//
//  Database is invalid.
//
#define TLR_E_PROFIBUS_APS_CONFIG_DBM_INVALID ((TLR_RESULT)0xC01D0004L)

//
// MessageId: TLR_E_PROFIBUS_APS_CONFIG_MODULE_LENGTH
//
// MessageText:
//
//  Modul configuration consists invalid length.
//
#define TLR_E_PROFIBUS_APS_CONFIG_MODULE_LENGTH ((TLR_RESULT)0xC01D0005L)

//
// MessageId: TLR_E_PROFIBUS_APS_CFG_DATA_INVALID_LENGTH
//
// MessageText:
//
//  Configuration data invalid length.
//
#define TLR_E_PROFIBUS_APS_CFG_DATA_INVALID_LENGTH ((TLR_RESULT)0xC01D0006L)

//
// MessageId: TLR_E_PROFIBUS_APS_CFG_DATA_INCONSISTENT
//
// MessageText:
//
//  Configuration data inconsistent.
//
#define TLR_E_PROFIBUS_APS_CFG_DATA_INCONSISTENT ((TLR_RESULT)0xC01D0007L)

//
// MessageId: TLR_E_PROFIBUS_APS_CFG_DATA_MAX_IO_LEN_EXCEEDED
//
// MessageText:
//
//  Configuration data maximum I/O length exceeded.
//
#define TLR_E_PROFIBUS_APS_CFG_DATA_MAX_IO_LEN_EXCEEDED ((TLR_RESULT)0xC01D0008L)

//
// MessageId: TLR_E_PROFIBUS_APS_RESET_PENDING
//
// MessageText:
//
//  Reset of APS task is pending.
//
#define TLR_E_PROFIBUS_APS_RESET_PENDING ((TLR_RESULT)0xC01D0009L)

//
// MessageId: TLR_E_PROFIBUS_APS_BAUDRATE_INVALID
//
// MessageText:
//
//  The specified baudrate option is not supported and is out of range.
//
#define TLR_E_PROFIBUS_APS_BAUDRATE_INVALID ((TLR_RESULT)0xC01D000AL)

//
// MessageId: TLR_E_PROFIBUS_APS_ADDR_INVALID
//
// MessageText:
//
//  The specified local profibus address option is not supported and is out of range 0-126.
//
#define TLR_E_PROFIBUS_APS_ADDR_INVALID  ((TLR_RESULT)0xC01D000BL)

//
// MessageId: TLR_E_PROFIBUS_APS_WDG_INVALID
//
// MessageText:
//
//  The specified host watchdog time is not supported and is out of range 0, 20-65535.
//
#define TLR_E_PROFIBUS_APS_WDG_INVALID   ((TLR_RESULT)0xC01D000CL)




#endif  //__PROFIBUS_APS_ERROR_H

